# Greatest common divisor algorithm.
def GCD(x, y):
  
   while(y):
       x, y = y, x % y
  
   return x


def arnolds_cat_map(x_num, x_denum, y_num, y_denum):

    # We define Arnolds cat map in terms of the numerator and denumerator of both points.
    x_num_new = 2 * x_num * y_denum + y_num * x_denum
    x_denum_new = x_denum * y_denum
    x_num_new = x_num_new - int(x_num_new / x_denum_new) * x_denum_new


    # Make sure that we work mod 1.
    y_num_new = x_num * y_denum + y_num * x_denum
    y_denum_new = x_denum * y_denum 
    y_num_new = y_num_new - int(y_num_new / y_denum_new) * y_denum_new


    # Make sure that we have the smallest possible numerator and denumerator.
    gcd_x = GCD(x_num_new, x_denum_new)
    x_num_new = int(x_num_new / gcd_x)
    x_denum_new = int(x_denum_new / gcd_x)

    gcd_y = GCD(y_num_new, y_denum_new)
    y_num_new = int(y_num_new / gcd_y)
    y_denum_new = int(y_denum_new / gcd_y)


    # Return the correct new numerators and denumerators.
    return (x_num_new, x_denum_new, y_num_new, y_denum_new)


# Function that calculate the period of a point under Arnold's cat map.
def period_catmap(x_num, x_denum, y_num, y_denum):

    # Define the initial point.
    point = (x_num, x_denum, y_num, y_denum)

    #  Define the first iteration.
    iteration = arnolds_cat_map(x_num, x_denum, y_num, y_denum)
    
    # Keep track of the numer of iterations we have done.
    count = 1

    # We keep iterating until we are back at the initial point.
    while True:

        # Increase the iteration count.
        count += 1

        # Get the new point.
        iteration = arnolds_cat_map(iteration[0], iteration[1], iteration[2], iteration[3] )
        

        # As soon as we end up at the initial point we stop iterating.
        if iteration == point:
            # print(count, iteration)
            break


        # Print information to check which iterations we have done.
        # print(count, iteration)


    #  Return the period of the point (x,y) under Arnold's cat map.
    return count


# Code to mimic the Domjudge input.
import os
import sys

test_number = 1

input_dir = os.path.abspath(os.path.join(os.path.dirname(__file__),'Testsets' ))
sys.stdin = open(os.path.join(input_dir, f'Testset0{test_number}.txt'),'r')
x_num, x_denum = [ int(i) for i in input().split(' ') ]
y_num, y_denum = [ int(i) for i in input().split(' ') ]
l = int(input())
k = int(10**l)

# # Domjudge code.
# x_num, x_denum = [ int(i) for i in input().split(' ') ]
# y_num, y_denum = [ int(i) for i in input().split(' ') ]
# l = int(input())
# k = int(10**l)

# Calculate period of the point under Arnold's Cat Map.
period = period_catmap(x_num, x_denum, y_num, y_denum)
remainder = k % period

# Determine the trajectory of the remaining transformation.
for i in range(remainder):
    x_num, x_denum, y_num, y_denum = arnolds_cat_map(x_num, x_denum, y_num, y_denum)

# Print the final answer.
print(f'{x_num} {x_denum}')
print(f'{y_num} {y_denum}')